/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken.update;

import com.floragunn.searchguard.authtoken.AuthTokenService;
import com.floragunn.searchguard.authtoken.update.PushAuthTokenUpdateNodeResponse;
import com.floragunn.searchguard.authtoken.update.PushAuthTokenUpdateRequest;
import com.floragunn.searchguard.authtoken.update.PushAuthTokenUpdateResponse;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPushAuthTokenUpdateAction
extends TransportNodesAction<PushAuthTokenUpdateRequest, PushAuthTokenUpdateResponse, NodeRequest, PushAuthTokenUpdateNodeResponse> {
    private final AuthTokenService authTokenService;

    @Inject
    public TransportPushAuthTokenUpdateAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, AuthTokenService authTokenService) {
        super("cluster:admin/searchguard/auth_token/update/push", threadPool, clusterService, transportService, actionFilters, PushAuthTokenUpdateRequest::new, NodeRequest::new, "management", PushAuthTokenUpdateNodeResponse.class);
        this.authTokenService = authTokenService;
    }

    protected PushAuthTokenUpdateNodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new PushAuthTokenUpdateNodeResponse(in);
    }

    protected PushAuthTokenUpdateResponse newResponse(PushAuthTokenUpdateRequest request, List<PushAuthTokenUpdateNodeResponse> responses, List<FailedNodeException> failures) {
        return new PushAuthTokenUpdateResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected PushAuthTokenUpdateNodeResponse nodeOperation(NodeRequest request) {
        String status = this.authTokenService.pushAuthTokenUpdate(request.request);
        return new PushAuthTokenUpdateNodeResponse(this.clusterService.localNode(), status);
    }

    protected NodeRequest newNodeRequest(PushAuthTokenUpdateRequest request) {
        return new NodeRequest(request);
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        PushAuthTokenUpdateRequest request;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new PushAuthTokenUpdateRequest(in);
        }

        public NodeRequest(PushAuthTokenUpdateRequest request) {
            this.request = request;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

